<?php
/* --------------------------------------------------------------
 DeleteRegistryHandler.php 2020-04-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\Plugins\Utility;

use Gambio\Core\Application\Plugins\PluginRegistryService;

/**
 * Class DeleteRegistryHandler
 * @package Gambio\Core\Application\Plugins\Utility
 */
class DeleteRegistryHandler
{
    /**
     * @var PluginRegistryService
     */
    private $pluginRegistryService;
    
    
    /**
     * DeleteRegistryHandler constructor.
     *
     * @param PluginRegistryService $pluginRegistryService
     */
    public function __construct(PluginRegistryService $pluginRegistryService)
    {
        $this->pluginRegistryService = $pluginRegistryService;
    }
    
    
    /**
     * Command callback that deletes the plugin registry cache file.
     *
     * @param DeletePluginRegistry $command
     *
     * @return DeletePluginRegistry
     */
    public function __invoke(DeletePluginRegistry $command): DeletePluginRegistry
    {
        $this->pluginRegistryService->delete();
        
        return $command;
    }
}